package com.qboxus.tictic.activitesfragments.profile

import android.content.Intent
import android.os.Bundle
import android.view.View
import android.widget.AbsListView
import androidx.databinding.DataBindingUtil
import androidx.lifecycle.ViewModelProvider
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.qboxus.tictic.R
import com.qboxus.tictic.adapters.FollowingAdapter
import com.qboxus.tictic.apiclasses.ApiResponce
import com.qboxus.tictic.databinding.ActivityViewProfileHistoryBinding
import com.qboxus.tictic.models.UserModel
import com.qboxus.tictic.repositories.UserRepository
import com.qboxus.tictic.simpleclasses.AppCompatLocaleActivity
import com.qboxus.tictic.simpleclasses.Functions.cancelLoader
import com.qboxus.tictic.simpleclasses.Functions.checkLoginUser
import com.qboxus.tictic.simpleclasses.Functions.checkProfileOpenValidation
import com.qboxus.tictic.simpleclasses.Functions.getSharedPreference
import com.qboxus.tictic.simpleclasses.Functions.printLog
import com.qboxus.tictic.simpleclasses.Functions.setLocale
import com.qboxus.tictic.simpleclasses.Functions.showLoader
import com.qboxus.tictic.simpleclasses.Functions.showToast
import com.qboxus.tictic.simpleclasses.Variables
import com.qboxus.tictic.viewModels.ProfileViewsFactory
import com.qboxus.tictic.viewModels.ProfileViewsViewModel

class ViewProfileHistoryActivity : AppCompatLocaleActivity() {
    lateinit var binding: ActivityViewProfileHistoryBinding

    val dataList = mutableListOf<UserModel>()

    lateinit var adapter: FollowingAdapter
    lateinit var linearLayoutManager: LinearLayoutManager

    lateinit var viewModel: ProfileViewsViewModel
    private val userRepository = UserRepository()

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setLocale(
            getSharedPreference(this).getString(
                Variables.APP_LANGUAGE_CODE,
                Variables.DEFAULT_LANGUAGE_CODE
            ), this, javaClass, false
        )
        binding = DataBindingUtil.setContentView(this, R.layout.activity_view_profile_history)

        val viewModelProviderFactory = ProfileViewsFactory(this,userRepository)
        viewModel = ViewModelProvider(this,viewModelProviderFactory)[ProfileViewsViewModel::class.java]
        binding.viewModel=viewModel
        binding.lifecycleOwner = this

        binding.rootShimmer.shimmerViewContainer.startShimmer()
        initControl()
        actionControl()
        setObserveAble()
    }


    fun setObserveAble(){

        viewModel.listLiveData.observe(this,{
            when(it){
                is ApiResponce.Success ->{
                    it.data?.let {
                        if (it != null) {

                            if (viewModel.pageCount.get() == 0) {
                                dataList!!.clear()
                            }
                            dataList!!.addAll(it)
                            adapter!!.notifyDataSetChanged()
                        }

                        changeUi()
                    }

                }

                is ApiResponce.Error ->{

                    if (viewModel.pageCount.get() == 0) {
                        dataList!!.clear()
                        adapter!!.notifyDataSetChanged()
                    }
                    else{

                        viewModel.pageCount.set(viewModel.pageCount.get()-1)
                        if(!it.isRequestError){
                            viewModel.ispostFinsh=true
                        }
                    }


                    changeUi()
                }

                else -> {}
            }
        })

        viewModel.followLiveData.observe(this,{
            when(it){
                is ApiResponce.Success ->{
                    it.data?.let { userModel->
                        if (userModel != null) {
                            for ((index,item) in dataList!!.withIndex()) {
                                if(item.id.equals(userModel.id)){

                                    dataList!![index] = userModel
                                    adapter!!.notifyItemChanged(index, userModel)
                                    break
                                }
                            }
                        }
                    }

                }
                else -> {}
            }
        })


        viewModel.editProfileLiveData.observe(this,{
            when(it){
              is ApiResponce.Loading->{
                  showLoader(this@ViewProfileHistoryActivity, false, false)

              }

                is ApiResponce.Success ->{
                    cancelLoader()
                    val editor = getSharedPreference(binding!!.root.context).edit()
                    editor.putString(Variables.U_PROFILE_VIEW, "1")
                    editor.commit()
                    isActivityCallback = true
                    setupScreenData()
                }

                is ApiResponce.Error ->{
                    cancelLoader()
                    if (it.message != null) {
                        showToast(binding!!.root.context,it.message)
                    }
                }
            }
        })

    }

    fun changeUi(){
        if (dataList!!.isEmpty()) {
            viewModel.showNoDataView()
        } else {
            viewModel.showDataView()
        }

        binding!!.rootShimmer.shimmerViewContainer.visibility = View.GONE
        binding!!.rootShimmer.shimmerViewContainer.stopShimmer()
        viewModel.loadMoreProgressVisibility.set(false)
        binding!!.viewflliper.visibility = View.VISIBLE
        if (dataList.isEmpty()) {
            binding!!.tvVisitorInfo.visibility = View.GONE
        } else {
            isActivityCallback = true
            binding!!.tvVisitorInfo.visibility = View.VISIBLE
        }


    }




    private fun actionControl() {
        binding!!.ivBack.setOnClickListener { onBackPressed() }
        binding!!.ivSetting.setOnClickListener { openProfileViewSetting() }
        binding!!.tabNotNow.setOnClickListener { onBackPressed() }
        binding!!.tabTurnOn.setOnClickListener {
            viewModel.updateProfileViewStatus()
        }
    }

    private fun openProfileViewSetting() {
        val fragment = EditProfileViewRuleSheetFragment { bundle ->
            if (bundle.getBoolean("isShow", false)) {
                setupScreenData()
                isActivityCallback = true
            }
        }
        fragment.show(supportFragmentManager, "EditProfileViewRuleF")
    }

    private fun initControl() {
        linearLayoutManager = LinearLayoutManager(binding!!.root.context)
        linearLayoutManager!!.orientation = RecyclerView.VERTICAL
        binding!!.recylerview.layoutManager = linearLayoutManager
        binding!!.recylerview.setHasFixedSize(true)
        setupAdapter()
        setupScreenData()
    }

    private fun setupAdapter() {
        adapter = FollowingAdapter(
            binding!!.root.context,
            dataList,
            object : FollowingAdapter.OnItemClickListener {
                override fun onItemClick(view: View?, postion: Int, item: UserModel?) {
                    when (view!!.id) {
                        R.id.action_txt -> if (checkLoginUser(this@ViewProfileHistoryActivity)) {
                            if (item!!.id != getSharedPreference(
                                    binding!!.root.context
                                ).getString(Variables.U_ID, "")
                            ) {
                                viewModel.followUser(""+item?.id)

                            }
                        }

                        R.id.mainlayout -> openProfile(item)
                    }
                }
            }
        )
        binding!!.recylerview.adapter = adapter
        binding!!.recylerview.addOnScrollListener(object : RecyclerView.OnScrollListener() {
            var userScrolled = false
            var scrollOutitems = 0
            override fun onScrollStateChanged(recyclerView: RecyclerView, newState: Int) {
                super.onScrollStateChanged(recyclerView, newState)
                if (newState == AbsListView.OnScrollListener.SCROLL_STATE_TOUCH_SCROLL) {
                    userScrolled = true
                }
            }

            override fun onScrolled(recyclerView: RecyclerView, dx: Int, dy: Int) {
                super.onScrolled(recyclerView, dx, dy)
                scrollOutitems = linearLayoutManager!!.findLastVisibleItemPosition()
                printLog("resp", "" + scrollOutitems)
                if (userScrolled && scrollOutitems == dataList.size - 1) {
                    userScrolled = false
                    if (viewModel.loadMoreProgressVisibility.get() == false && !viewModel.ispostFinsh) {

                        viewModel.loadMoreProgressVisibility.set(true)
                        viewModel.pageCount.set(viewModel.pageCount.get()+1)
                        viewModel.getProfileViewsList()
                    }
                }
            }
        })
        binding!!.refreshLayout.setOnRefreshListener {
            binding!!.refreshLayout.isRefreshing = false
            viewModel.pageCount.set(0)
            viewModel.getProfileViewsList()
        }
    }

    private fun openProfile(item: UserModel?) {
      if (checkProfileOpenValidation(item?.id)) {
            val intent = Intent(binding!!.root.context, ProfileActivity::class.java)
            intent.putExtra("user_id", "" + item?.id)
            intent.putExtra("user_name", "" + item?.username)
            intent.putExtra("user_pic", "" + item?.getProfilePic())
            startActivity(intent)
            overridePendingTransition(R.anim.in_from_right, R.anim.out_to_left)
        }
    }

    private fun setupScreenData() {
       val profileView = getSharedPreference(binding!!.root.context).getString(Variables.U_PROFILE_VIEW, "0")

        if (profileView == "1") {
            if (binding!!.viewflliper.currentView === binding!!.containerHide) {
                binding!!.viewflliper.showNext()
            }
            binding!!.containerHide.alpha = 0f
            binding!!.containerShow.alpha = 1f
            binding!!.ivSetting.visibility = View.VISIBLE
            viewModel.pageCount.set(0)
            viewModel.getProfileViewsList()
        }
        else {
            if (binding!!.viewflliper.currentView === binding!!.containerShow) {
                binding!!.viewflliper.showPrevious()
            }
            binding!!.containerHide.alpha = 1f
            binding!!.containerShow.alpha = 0f
            binding!!.ivSetting.visibility = View.GONE
        }
    }


    var isActivityCallback = false
    override fun onBackPressed() {
        if (isActivityCallback) {
            val intent = Intent()
            intent.putExtra("isShow", true)
            setResult(RESULT_OK, intent)
        }
        finish()
    }
}